-- Script to automatically scan a user chosen text file, extract task items and send them to Things
-- Written by Luc Beaulieu, Version 1.1, March 9, 2015

set theFile to choose file with prompt "Select a text file:"
set theFileReference to open for access theFile
set theFileContents to read theFileReference
close access theFileReference

set theLines to paragraphs of theFileContents

-- Iterating through each line, one by one for the string "ACTION:"
set textDelim to "ACTION:"
set nTask to 0

repeat with eachLine in theLines
	set nextLine to eachLine
	set finalTask to ""
	if nextLine contains textDelim then
		set AppleScript's text item delimiters to textDelim
		set theTask to item 2 of every text item of nextLine
		set AppleScript's text item delimiters to ""
		set finalTask to finalTask & theTask & return
	end if
	
	if finalTask is not equal to "" then
		set nTask to nTask + 1
		tell application id "Thgs"
			make new to do with properties {name:finalTask}
		end tell
	end if
	
end repeat

display dialog (nTask as string) & " were created!"
